#include <iostream>
#include <cstdio>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

const int maxn = 1 << 17;
const double pi = acos(-1.0);

int n, m;
int x[maxn], y[maxn];
vector<int> e[maxn];

double dif(double a, double b) {
	if (a > b) swap(a, b);
	return pi - min(b - a, a + 2 * pi - b);
}

int main() {
	freopen("input.txt", "r", stdin);

	while (cin >> n >> m) {
		for (int i = 0; i < n; i++) {
			cin >> x[i] >> y[i];
			e[i].clear();
		}
		for (int i = 0; i < m; i++) {
			int u, v;
			cin >> u >> v;
			e[u].push_back(v);
			e[v].push_back(u);
		}
		double ans = 0;
		for (int i = 0; i < n; i++) {
			vector<double> vct;
			for (int j = 0; j < (int)e[i].size(); j++) {
				double dx = x[e[i][j]] - x[i];
				double dy = y[e[i][j]] - y[i];
				vct.push_back(atan2(dy, dx));
			}
			sort(vct.begin(), vct.end());
			if (vct.size() == 2) {
				ans += dif(vct[0], vct[1]);
			} else {
				double res = 1e20;
				res = min(res, dif(vct[0], vct[1]) + dif(vct[2], vct[3]));
				res = min(res, dif(vct[1], vct[2]) + dif(vct[0], vct[3]));
				res = min(res, dif(vct[0], vct[2]) + dif(vct[1], vct[3]));
				ans += res;
			}
		}
		printf("%.10lf\n", ans);
	}

	return 0;
}